#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../common/cancel_appointment'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/booked_appointment_detail'
require_relative '../../helper/modal'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../helper/error_validation'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/feedback'
require_relative '../../pages/landing_notifications'


describe '[Story# VAR-1928: New Appointment - Enter Details]
          [Story# VAR-1921: New Appointment/Request - Appointment vs Request Routing Question Updates]
          [Story# VAR-2652: New Appointment – Appointment Detail Updates - Dynamic Clinic list]
          [Story# VAR-2770: New Appointment - Preferred Date Display]'  do

  include DriverUtility
  include OracleUtility
  include DateUtility
  include MongoUtility


  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    @detail = BookedAppointmentDetail.new(@driver)
    @error = Error_Validation.new(@driver)
    @feedback = Feedback.new(@driver)
    @landing_notifications = LandingNotifications.new(@driver)
    TITLE = "Appointments/Requests"
    @tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
    @sevenDaysFromNow = getDateNthDaysFromNow(7, "%m/%d/%Y")
    @nintyDaysLater = getDateNthDaysFromNow(90, "%m/%d/%Y")
    @@patientID ="1113138327"
    #cancel appointment
    @cancel_appointment = CancelAppointment.new("CLINIC_BASED_BOSTON", "523","#{pw_redacted['userid']}")
    @cancel_appointment.update_appointment_obj("appointmentTime", "#{@sevenDaysFromNow} 10:00:00")
    @cancel_appointment.cancel_appointment()
    #mongo
    @db = connectToMongoDB("var-utility")
    restoreCollection("siteSupportingVAR", "var-utility", "sites-supporting-var-exported2.json", @db)
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    restoreCollection("directBookingEligibilityCriteria", "var-utility", "directSchedulingEnabled.json", @db)
    restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
    restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name.json", @db)
    deletePatientData(@@patientID)
    @common.loginEndsOnHome(pw_redacted)
    @common.selectAddAppointmentButton("VA")
    @@timeSlot = "10:00"
    @clinic_friendly_name ="JP PRIMARY CARE DR. CREAMER"
    @location = "BOSTON HCS VAMC"
    ## The clinic name is diff in cdw v/s mdws but in real world its same per Chris. We may need to update this test once clinic name
    # for details, list and appointment form is being pulled from same place
    @clinic = "BOPACTB1"
  end

  after(:all) do
    @driver.close
  end

  context 'AC#VAR-2759|TC#VAR-2765: New Appointment - Enter Details criteria
           AC#VAR-3348|VAR-3459: New Appointment/Request - Routing Criteria
           AC#VAR-3485|TC#VAR-3486: Validate - Dynamic Clinic list based on the Facility and Type of Care selected.
           AC#VAR-3505|TC#VAR-3639: Preferred date criteria' do

    it "Verify Appointment Details form is loaded" do
      @new_appointment.selectTypeOfCare(PRIMARY_CARE)
      @new_appointment.selectState("523")
      @new_appointment.selectLocation("523")
      @new_appointment.selectSchedulingMethod("direct")
      expect(@new_appointment.appointment_details_legend).to eq("Appointment Details")
    end

    it "Multi State: should verify labels and options on new appointment form" do
      @new_appointment.selectClinic("32")

      expected_content =[\
                        "* required field",
                        "Step 1: Type of Care",
                        "The VA Appointments app supports scheduling specific types of care. If you do not find the care you need, please contact your facility for assistance.",
                        "* Select the type of care you need:",
                        "Select",
                        "Primary Care",
                        "Audiology",
                        "Express Care",
                        "Optometry",
                        "Outpatient Mental Health",
                        "Step 2: City, State",
                        "* Choose the closest city and state for this appointment:",
                        "Select",
                        "Des Moines, IA",
                        "Iowa City, IA",
                        "BOSTON, MA",
                        "Omaha, NE",
                        "Step 3: Location",
                        "The following facility locations support scheduling Primary Care appointments through this app. If you cannot find the location you need, please visit the VA Facility Locator to contact the facility for assistance.",
                        "* Select the location you want to visit:",
                        "Select",
                        "BOSTON HCS VAMC (BOSTON, MA) - Your Primary Care Team",
                        "BROCKTON VAMC (BROCKTON, MA)",
                        "QUINCY (QUINCY, MA)",
                        "Providers:",
                        "Creamer, Kent",
                        "Your Care Team (PACT)",
                        "Your Care Team (PACT) for BOSTON HCS VAMC",
                        "Step 4: Scheduling Method",
                        "The location you selected supports the following scheduling methods:",
                        "* Select a scheduling method:",
                        "Schedule Myself",
                        "Submit a Request to VA Scheduler",
                        "Appointment Details",
                        "* Select Clinic:",
                        "BO PACT B1",
                        "JP PRIMARY CARE DR. CREAMER",
                        "BO PCC QUICK ACCESS AM 2204",
                        "Primary Care - No Time Slot",
                        "If you don't see the clinic that matches your needs, contact your facility for assistance.",
                        "* Reason for Appointment:",
                        "(150 char limit)",
                        "150 characters remaining",
                        "* Preferred Date:",
                        "Appointments may be scheduled between " + @tomorrow + " and " +@nintyDaysLater+ ".",
                        "Show Availability",
                        "Email Preferences",
                        "Send me updates on my appointments and requests:",
                        "Information about updates on my appointments and requests",
                        "Yes",
                        "No",
                        "Schedule Appointment Cancel"]


      actual_content = @new_appointment.getScreenContent.split("\n")
      expected_content.each_with_index do | expectedScreenRow, i |
        expect(expectedScreenRow.strip).to include(actual_content[i].strip)
      end

    end


    it "Should verify Multiple facility: Verify static text for multiple facilities" do
      #log in as a diff user. if user has more then one DFN, then display a radio button list of all facilities
      restoreCollection("directBookingEligibilityCriteria", "var-utility", "directSchedulingEnabled.json", @db)
      restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
      @new_appointment.cancelForm
      @common.logoutAndLogbackWithADifferentUser(pw_redacted)
      @common.selectAddAppointmentButton("VA")
      @new_appointment.selectTypeOfCare(AUDIOLOGY)
      @new_appointment.selectState("523")

      expected_content =[\
                        "Step 3: Location",
                        "The following facility locations support scheduling #{AUDIOLOGY} appointments through this app. If you cannot find the location you need, please visit the VA Facility Locator to contact the facility for assistance.",
                        "* Select the location you want to visit:",
                        "Select",
                        "BOSTON HCS VAMC (BOSTON, MA)",
                        "BROCKTON VAMC (BROCKTON, MA)",
                        "QUINCY (QUINCY, MA)"
      ]

      actual_content = @new_appointment.facility_section_element.text.split("\n")

      compareContents( expected_content, actual_content)

    end

    it "Should verify Single clinic: Verify Single clinic label " do
      @new_appointment.selectTypeOfCare(OPTOMETRY)
      @new_appointment.selectState("523")
      @new_appointment.selectLocation("523")
      @new_appointment.selectSchedulingMethod("direct")
      if (@modal.isModalPopUpPresent)
          @modal.buttons_elements[0].click
          @common.waitWhileSpinnerPresent()
          sleep 2
      end
      @new_appointment.single_clinic_label_element.when_visible(TIME_OUT_LIMIT)
      expect(@new_appointment.single_clinic_label).to eq("Clinic:")
    end

    it "should verify Single clinic: only single clinic displayed with friendly name " do
      clinicInfo = ["ZZPJH OPTOMETRY", "Test Optometry"]
      actualClinicInfo = @new_appointment.single_clinic_info_element.text.split("\n")
      compareContents(clinicInfo, actualClinicInfo)
    end

    it "should verify When changing facility, form nullifies all subsequent fields" do
      @new_appointment.selectTypeOfCare(PRIMARY_CARE)
      @new_appointment.selectState("523")
      @new_appointment.selectLocation("523")
      @new_appointment.selectSchedulingMethod("direct")
      #when changing facility, it nullifies all subsequent fields
      sleep 2
      @new_appointment.selectLocation("523A5")
      @common.waitWhileSpinnerPresent()
      sleep 2
      @new_appointment.type_of_care_element.when_visible(TIME_OUT_LIMIT)
      expect(@new_appointment.scheduling_method_radio_elements[0].selected?).to eq(false)
    end

    it "should verify Multiple clinic: Verify Multiple clinics label" do

      @new_appointment.selectTypeOfCare(AUDIOLOGY)
      @new_appointment.selectState("523")
      @new_appointment.selectLocation("523")
      @common.waitWhileSpinnerPresent()
      @new_appointment.select_scheduling_method_radio("direct")
      @new_appointment.multi_clinic_label_element.when_present(TIME_OUT_LIMIT)
      expect(@new_appointment.multi_clinic_label).to eq("* Select Clinic:")

    end

    it "Multiple clinic: Verify Multiple clinics displayed in list" do

      clinicInfo1 = ["BO RHEUM DUBREUIL", "Audiology Clinic"]
      clinicInfo2 = ["ZZBO LANGUAGE PATHOLOGY GR"]


      clinicGroup1 = @new_appointment.clinic_group_elements[0].text.split("\n")
      compareContents(clinicInfo1, clinicGroup1)

      clinicGroup2 = @new_appointment.clinic_group_elements[1].text.split("\n")
      compareContents(clinicInfo2, clinicGroup2)

    end

    it "Verify Clinic field is required" do
      @new_appointment.clickScheduleAppointment
      verifyErrorMessage("Select Clinic field is required.")

    end

    it "Verify Clinic can be selected" do

      @new_appointment.selectClinic("64")
      expect(@new_appointment.clinic_radio_selected?).to eq("64")
      expect(@new_appointment.clinic_radio_elements[0].enabled?).to eq(true)
      expect(@new_appointment.clinic_radio_elements[1].enabled?).to eq(true)
    end

    it "Verify selecting clinic loads reason for appointment option" do
      @new_appointment.selectNewAppointmentAndSchedule(PRIMARY_CARE, "523","523", "direct")
      @new_appointment.selectClinic("32")
      @new_appointment.reason_element.when_present(TIME_OUT_LIMIT)
      @new_appointment.preferred_date_element.when_present(TIME_OUT_LIMIT)
      expect(@new_appointment.reason_element.present?).to eq(true)
    end

    it "Reason for Appointment is required" do
      @new_appointment.clickScheduleAppointment
      verifyErrorMessage("Reason for Appointment field is required.")

    end

    it "Adds Reason for Appointment: maximum character can be entered" do
      char50 = "MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50"
      @new_appointment.reason = char50
      #expect(@new_appointment.reason).to eq(char50)
      @new_appointment.reason = char50 + char50 + char50
      @new_appointment.reason_element.fire_event('onblur')
      expect(@new_appointment.reason).to eq(char50 + char50 + char50)

    end

    it "Verify preferred date option is present" do
      expect(@new_appointment.preferred_date_element.present?).to eq(true)
    end

    it "Verify Preferred date is required" do
      @new_appointment.clickScheduleAppointment
      verifyErrorMessage("Preferred Date field is required.")
    end

    it "Verify Preferred date default message" do

      expect(@new_appointment.preferred_date_info_text).to eq("Appointments may be scheduled between " + @tomorrow + " and " + @nintyDaysLater + ".")

    end

    it "Verify Preferred date error message for range" do
      @new_appointment.preferred_date =  getDateNthDaysFromNow(0, "%m/%d/%Y")
      @new_appointment.clickScheduleAppointment
      verifyErrorMessage("Please enter a date between " + @tomorrow + " and " + @nintyDaysLater + ".")
    end

    it "should Verify instructional text Showing all available dates." do
      @new_appointment.preferred_date =  @sevenDaysFromNow
      @new_appointment.show_availability
      @new_appointment.show_all_dates_element.when_present(TIME_OUT_LIMIT)
      @new_appointment.show_all_dates
      expect(@new_appointment.select_datetime_instr_text).to eq("Showing all available dates.")
    end

    it "Should verify date element for 90 days later is present" do
      expect(@new_appointment.isDateElementPresent(getDateNthDaysFromNow(90, "%m/%d/%Y"))).to eq(true)

    end

    it "should verify that no date element for more than 90 days is present" do
      expect(@new_appointment.isDateElementPresent(getDateNthDaysFromNow(91, "%m/%d/%Y"))).to eq(false)
    end

    it "Select Date/Time is required" do
      @new_appointment.schedule_appointment
      verifyErrorMessage("Select Date/Time field is required.")
=begin
      Watir::Wait.until { @new_appointment.isDateElementPresent(threeDaysLater)}
      #info text
      expect(@new_appointment.select_datetime_instr_text).to eq("Showing all available dates.")

      #February Expanded, threeDaysLater Expanded
      expect(@new_appointment.isElementCollapsed( @new_appointment.getMonthElement( getMonthOfYear(threeDaysLater, "%B"), getYear(threeDaysLater) ))).to eq(false)
      expect(@new_appointment.isElementCollapsed( @new_appointment.getDateElement(threeDaysLater))).to eq(false)
      expect(@new_appointment.getTimeSlotElement(threeDaysLater, "09:00").visible?).to eq(true)

      expect(@new_appointment.getMonthElement( getMonthOfYear(threeDaysLater, "%B"), getYear(threeDaysLater) ).text).to include("select to collapse content")

      expect(@new_appointment.isElementCollapsed( @new_appointment.getDateElement(getDateNthDaysFromNow(23, "%m/%d/%Y")))).to eq(true)
      expect(@new_appointment.isElementCollapsed( @new_appointment.getDateElement(getDateNthDaysFromNow(57, "%m/%d/%Y")))).to eq(true)
      expect(@new_appointment.isElementCollapsed( @new_appointment.getDateElement(getDateNthDaysFromNow(74, "%m/%d/%Y")))).to eq(true)
      expect(@new_appointment.isElementCollapsed( @new_appointment.getDateElement(getDateNthDaysFromNow(81, "%m/%d/%Y")))).to eq(true)

      expect(@new_appointment.getDateElement(getDateNthDaysFromNow(57, "%m/%d/%Y")).text).to include("select to expand content")

      #no matching date
      ninteenDaysLater = getDateNthDaysFromNow(19, "%m/%d/%Y")
      @new_appointment.preferred_date = ninteenDaysLater
      @new_appointment.show_availability
      @new_appointment.show_all_dates

      expect(@new_appointment.isDateElementPresent(ninteenDaysLater)).to eq(false)
      expect(@new_appointment.isAllDatesCollapsed).to eq(true)

      #today + 90 days
      expect(@new_appointment.isDateElementPresent(@nintyDaysLater)).to eq(true)
      expect(@new_appointment.isDateElementPresent(getDateNthDaysFromNow(91, "%m/%d/%Y"))).to eq(false)

      #clear preferred date
      @new_appointment.preferred_date =  ""
      @new_appointment.preferred_date_element.send_keys :enter
      Watir::Wait.until {  @new_appointment.show_availability_element.enabled? == false}
      #select date/time field becomes hidden
      expect(@new_appointment.show_availability_element.enabled?).to eq(false)

      fiftySevenDaysLater = getDateNthDaysFromNow(57, "%m/%d/%Y")
      @new_appointment.preferred_date = fiftySevenDaysLater
      @new_appointment.show_availability
      @new_appointment.show_all_dates

      Watir::Wait.until { @new_appointment.isDateElementPresent(fiftySevenDaysLater)}

      expect(@new_appointment.isAllDatesCollapsed).to eq(false)
      expect(@new_appointment.isElementCollapsed( @new_appointment.getMonthElement( getMonthOfYear(fiftySevenDaysLater, "%B"), getYear(fiftySevenDaysLater) ))).to eq(false)
      expect(@new_appointment.isElementCollapsed( @new_appointment.getDateElement(fiftySevenDaysLater))).to eq(false)
      expect(@new_appointment.getTimeSlotElement(fiftySevenDaysLater, "08:00").visible?).to eq(true)
      expect(@new_appointment.getTimeSlotElement(fiftySevenDaysLater, "10:00").visible?).to eq(true)
      expect(@new_appointment.getTimeSlotElement(fiftySevenDaysLater, "10:30").visible?).to eq(true)
      expect(@new_appointment.getTimeSlotElement(fiftySevenDaysLater, "13:30").visible?).to eq(true)

      @new_appointment.schedule_appointment
      verifyErrorMessage("Select Date/Time field is required.")

      @new_appointment.selectTimeSlot(fiftySevenDaysLater, "10:30")
      expect(@new_appointment.selected_datetime_info_label + " " + @new_appointment.selected_datetime_info).to eq("You are scheduling an appointment for: " + getDayofWeek(fiftySevenDaysLater) + ", " +fiftySevenDaysLater + " 10:30")
    end
=end
    end

    it "Should verify month and preferred date slot is expanded" do
      expect(@new_appointment.isElementCollapsed( @new_appointment.getMonthElement( getMonthOfYear(@sevenDaysFromNow, "%B"), getYear(@sevenDaysFromNow) ))).to eq(false)
      expect(@new_appointment.isElementCollapsed( @new_appointment.getDateElement(@sevenDaysFromNow))).to eq(false)
      expect(@new_appointment.getTimeSlotElement(@sevenDaysFromNow, @@timeSlot).visible?).to eq(true)
    end

    it "Should verify select to collapse content instrution" do
      expect(@new_appointment.getMonthElement( getMonthOfYear(@sevenDaysFromNow, "%B"), getYear(@sevenDaysFromNow) ).text).to include("select to collapse content")
    end

    it "Should verify select to expand content instruction" do
      expect(@new_appointment.getDateElement(getDateNthDaysFromNow(57, "%m/%d/%Y")).text).to include("select to expand content")

    end

    it "should Verify cleareing preferred dates hides the show availabilty selection" do
      @new_appointment.preferred_date =  ""
      @new_appointment.preferred_date_element.send_keys :enter
      Watir::Wait.until {  @new_appointment.show_availability_element.enabled? == false}
      #select date/time field becomes hidden
      expect(@new_appointment.show_availability_element.enabled?).to eq(false)
    end

    it "should select preferred date" do
      @new_appointment.selectPreferedDate(@sevenDaysFromNow, @@timeSlot)
      @@setDate = NewAppointmentRequest.bookedDate
    end

    it "Should verify the slot selection" do
      expect(@new_appointment.selected_datetime_info_label + " " + @new_appointment.selected_datetime_info).to eq("You are scheduling an appointment for: " + getDayofWeek(@@setDate) + ", " +@@setDate + " #{@@timeSlot}")
    end

    it "should Validate Email Preference and Submit" do
      @new_appointment.select_emailPref("true")
      expect(@new_appointment.emailPref_elements[0].selected?).to eq(true)
      expect(@new_appointment.emailPref_elements[1].selected?).to eq(false)
    end

    it "Validate Email field is required" do
      @new_appointment.email = ""
      @new_appointment.clickScheduleAppointment
      verifyErrorMessage("Email field is required.")
    end

    it "should verify Schedule appointment is successfull" do
      @new_appointment.email = "patient51@test.com"
      @new_appointment.email_element.fire_event('onblur')
      @new_appointment.clickScheduleAppointment
      @detail.appointment_details_group_element.when_present(TIME_OUT_LIMIT)
      expect(@detail.primary_header).to eq("Appointment Details")
    end

    it "Should verify Appointment Details status is scheduled" do
      #status
      Watir::Wait.until {@detail.appointment_details_group_element.present?}
      Watir::Wait.until {@detail.appointment_details_group_element.text.include?("Reason for Appointment")}
      expect(@detail.appointment_status_group_element.text).to eq("Status:  Scheduled")
    end

    it "Should verify Provide Feedback link is displayed on Submission Confirmation page" do
      expect(@detail.feedbackLink_element.text).to eq("Provide feedback on this submission.")
    end

    it "Should verify appointment details for date/time, clinic and Reason for Appointment" do
      @@selectedDay = getDayofWeek(@@setDate)
      @@timeSlot = @@timeSlot.gsub!(':', '')
      expected_text = [\
          "Date and Time:" + " #{@@selectedDay}," + " #{@@setDate}",
          "Date:" + " #{@@selectedDay},"+ " #{@@setDate}",
          @@timeSlot,
          "Time: #{@@timeSlot.gsub("", " ")}",
          "Add to Calendar",
          "Details: " + "#{@location}",
          "#{@clinic_friendly_name}",
          "Also called: #{@clinic}",
          "Please arrive 30 minutes before your scheduled time unless otherwise directed. VA Facility Locator",
          "Cancel Appointment",
          "Reason for Appointment: MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50"
      ]
      actual_text = @detail.appointment_details_group_element.text.split("\n")
      actual_text = actual_text.reject { |c| c.empty? }
      expected_text.each_with_index do | expectedScreenRow, i |
        expect(actual_text[i].gsub(/\s+/, '')).to eq(expectedScreenRow.gsub(/\s+/, ''))
      end
    end

    it "Email DB Validation" do
      emailId = executeAndGetDataAndNumRow("SELECT EMAIL_ADDRESS FROM VARDB.NOTIFICATION_PREFERENCE WHERE PATIENT_ID = '#{@@patientID}'")
      emailArr = emailId.split("||")
      expect(emailArr[0]).to eq("patient51@test.com")
    end

    it "should click on Feedback link and submit feedback" do
      @detail.feedbackLink
      @feedback.selectFeedbackondefullform("5")
      @feedback.feedback_comment="This is a Test"
      @feedback.feedback_submit
      @landing_appointments.primary_header_element.when_present(TIME_OUT_LIMIT)
      @common.waitWhileSpinnerPresent
      expect(@feedback.thanks_msg_element.text).to eq("Thank you! Your feedback has been submitted.")
    end

    it "should verify User has been navigated back to Appointment/Request landing page" do
      button_element = @driver.button(:id => 'back-btn')
      @driver.execute_script("$(arguments[0]).click();",button_element)
      @landing_appointments.appointment_header_element.when_present(TIME_OUT_LIMIT)
      expect(@landing_appointments.has_expected_title?).to eq(true)
    end

  end

end








